﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;

namespace xamMenuFun
{
    /// <summary>
    /// HierarchicalElementLocation class
    /// </summary>
    public class HierarchicalElementLocation
    {
        #region Field

        private string _name;       
        private double _location;
        private double _offset;
        private bool _isGroupPanelVisible;        
        private IList<HierarchicalElementLocation> _children;        
        
        #endregion Field

        #region Properties

        /// <summary>
        /// The name of the element.
        /// </summary>
        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }

        /// <summary>
        /// The element's location as a value indicating the cummulative aggregation of panel heights from its parent UI element.
        /// </summary>
        public double Location
        {
            get { return _location; }
            set { _location = value; }
        }

        /// <summary>
        /// The element's offset.
        /// </summary>
        public double Offset
        {
            get { return _offset; }
            set { _offset = value; }
        }

        /// <summary>
        /// The children elements.
        /// </summary>
        public IList<HierarchicalElementLocation> Children
        {
            get { return _children; }
            set { _children = value; }
        }

        /// <summary>
        /// Whether this location data should be used. This is determined
        /// by whether the group panel is visible.
        /// </summary>
        public bool IsGroupPanelVisible
        {
            get { return _isGroupPanelVisible; }
            set { _isGroupPanelVisible = value; }
        }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Instantiate a <see cref="HierarchicalElementLocation"/>
        /// </summary>
        /// <param name="name"></param>
        /// <param name="location"></param>
        /// <param name="offset"></param>
        /// <param name="isVisible"></param>
        public HierarchicalElementLocation(string name, double location, double offset, bool isVisible)
        {
            _name = name;
            _location = location;
            _offset = offset;
            _isGroupPanelVisible = isVisible;
        }

        /// <summary>
        /// Instantiate a <see cref="HierarchicalElementLocation"/>
        /// </summary>
        /// <param name="name"></param>
        /// <param name="location"></param>
        /// <param name="offset"></param>
        /// <param name="children"></param>       
        public HierarchicalElementLocation(string name, double location, double offset, bool isVisible, IList<HierarchicalElementLocation> children)
            : this(name, location, offset, isVisible)
        {
            _children = children;
        }

        #endregion Constructors

        #region Methods

        /// <summary>
        /// Add a child.
        /// </summary>
        /// <param name="name"></param>
        /// <param name="location"></param>
        /// <param name="offset"></param>
        /// <param name="isVisible"></param>
        public void AddChild(string name, double location, double offset, bool isVisible)
        {
            AddChild(new HierarchicalElementLocation(name, location, offset, isVisible));
        }

        /// <summary>
        /// Add a child.
        /// </summary>
        /// <param name="child"></param>
        public void AddChild(HierarchicalElementLocation child)
        {
            if (_children == null)
            {
                _children = new List<HierarchicalElementLocation>();
            }
            _children.Add(child);
        }

        #endregion Methods

        #region Events
        #endregion Events
    }
}
