﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Markup;
using System.Windows.Controls;
using System.Windows.Media;

using Infragistics.Windows;

namespace xamMenuFun

{
    public static class UIElementTreeHelper
    {
        public static object[] FindControls(this FrameworkElement f, Type childType, int maxDepth)
        {
            return RecursiveFindControls(f, childType, 1, maxDepth);
        }

        private static object[] RecursiveFindControls(object o, Type childType, int depth, int maxDepth = 0)
        {
            List<object> list = new List<object>();
            var attrs = o.GetType().GetCustomAttributes(typeof(ContentPropertyAttribute), true);
            if (attrs != null && attrs.Length > 0)
            {
                string childrenProperty = (attrs[0] as ContentPropertyAttribute).Name;
                if (String.Equals(childrenProperty, "Content") || 
                    String.Equals(childrenProperty, "Children"))
                {
                    var collection = o.GetType().GetProperty(childrenProperty).GetValue(o, null);
                    if (collection is UIElementCollection)
                    {
                        foreach (var c in (IEnumerable)collection)
                        {
                            if (c.GetType().FullName == childType.FullName)
                                list.Add(c);
                            if (maxDepth == 0 || depth < maxDepth)
                                list.AddRange(RecursiveFindControls(
                                    c, childType, depth + 1, maxDepth));
                        }
                    }
                    else if (collection != null && collection.GetType().BaseType.Name == "Panel") 
                    {
                        if (maxDepth == 0 || depth < maxDepth)
                            list.AddRange(RecursiveFindControls(
                                collection, childType, depth + 1, maxDepth));
                    }
                }
            }
            return list.ToArray();
        }

        public static IList<FrameworkElement> GetDescendantsFromType(DependencyObject parent, Type type)
        {
            IList<FrameworkElement> children = new List<FrameworkElement>();

            int count = VisualTreeHelper.GetChildrenCount(parent);

            if (count < 1)
                return children;

            FrameworkElement fe;

            for (int i = 0; i < count; i++)
            {
                fe = VisualTreeHelper.GetChild(parent, i) as FrameworkElement;
                if (fe != null)
                {
                    if (fe.GetType() == type)
                    {
                        children.Add(fe);
                    }

                    IList<FrameworkElement> subChildren = GetDescendantsFromType(fe, type);
                    if (subChildren.Count > 0)
                    {
                        foreach (FrameworkElement subElement in subChildren)
                        {
                            children.Add(subElement);
                        }
                    }
                }
            }

            return children;
        }
    }
}
